unit DataModule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type
  TDM = class(TDataModule)
    DSPDatabase: TDatabase;
    DSFilesGrp: TDataSource;
    TblFilesGrp: TTable;
    DSDSPComp: TDataSource;
    TblDSPComp: TTable;
    DSFilesCat: TDataSource;
    TblFilesCat: TTable;
    DSFilesPlt: TDataSource;
    TblFilesPlt: TTable;
    DSSitesCat: TDataSource;
    TblSitesCat: TTable;
    DSAuthors: TDataSource;
    TblAuthors: TTable;
    DSQueryFile: TDataSource;
    QueryFile: TQuery;
    DSFiles: TDataSource;
    TblFiles: TTable;
    DSFilesAut: TDataSource;
    TblFilesAut: TTable;
    procedure DMCreate(Sender: TObject);
    procedure DMDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    UseDSPDatabase: bool;
    ExecuteApp: bool;
  end;

var
  DM: TDM;

implementation

uses
   Upl_cons,
   Upl_dlg1;

{$R *.DFM}

procedure TDM.DMCreate(Sender: TObject);
var
 SL: TStringList;
 dlgresult: word;
 i: integer;

Begin
  ExecuteApp:= true;
  SL:= TStringList.Create;
  Session.GetAliasNames(SL);
  if SL.IndexOf(cUPL_DSP_ALIAS_NAME) >= 0  then
  Begin
    UseDSPDatabase:= true;
    DSPDatabase.Open;
    for i:= 0 to ComponentCount - 1 do
     if Components[i] is TTable then
    Begin
      try
        TTable(Components[i]).Open;
      except
        on EDatabaseError do
        if not TTable(Components[i]).Active then
          if MessageDlg('Couldn''t open ' + TTable(Components[i]).TableName + #13#10 +
                        'Continue anyway ?', mtConfirmation, [mbYes, mbNo], 0) = mrNo then
        Begin
          ExecuteApp:= false;
          Exit;
        End;
      end;
    End;
  end else
  Begin
    { DSP alias not defined - show message on the screen }
    UseDSPDatabase:= false;
    NoDSPDlg:= TNoDSPDlg.Create(nil);
    try
      ExecuteApp:= not ( NoDSPDlg.ShowModal = mrCancel );
    finally
      NoDSPDlg.Destroy;
    end;
    NoDSPDlg:= nil;
  end;
end;

procedure TDM.DMDestroy(Sender: TObject);
var
  i: integer;
begin
  for i:= 0 to ComponentCount - 1 do
   if Components[i] is TTable then
   Begin
     TTable(Components[i]).Close;
   End;
end;

end.
